package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.core.AgentSignature;

import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ScrollPane.ScrollBarPolicy;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class AgentSignatureForm {
	
	 private final Stage signatureForm = new Stage();
	 private ScrollPane scrollPane;
	 private final Scene signatureScene;
	 private static final Logger LOG = Logger.getLogger(EmailForm.class);
	
	 private HTMLEditor htmlEd=new HTMLEditor();
	 Button saveButton= new Button("Save");
	 
	 
	 VBox vbox= new VBox();
	 private UserExecutor userExe;
	 private String existingSignature;
	
	 
	 public AgentSignatureForm(String userId, UserExecutor userExe, String existingSignature, String css) {
		 String methodName = "AgentSignatureForm";
		 LOG.info(methodName, "Agent: " + userId );
		 this.existingSignature=existingSignature;
		 vbox.setPadding(new Insets(10));
		 vbox.getChildren().addAll(htmlEd, saveButton);
		 this.userExe=userExe;
		 htmlEd.setPrefHeight(400);
		 htmlEd.setPrefWidth(625);
		 
		 
		 String htmlSignature = existingSignature; 
		 
		 
		 saveButton.setOnAction((ActionEvent e) -> {
			 	LOG.info("AgentSignatureForm", "setting agent signature for Agent : " + userId + " to: " + htmlSignature);
	        	userExe.setAgentSignature(userId, htmlEd.getHtmlText());
		 });
		 
		 
		scrollPane= new ScrollPane();
    	scrollPane.setVbarPolicy(ScrollBarPolicy.AS_NEEDED);
    	scrollPane.setHbarPolicy(ScrollBarPolicy.NEVER);
    	scrollPane.setContent(vbox);
		 
		signatureScene = new Scene(scrollPane, 700, 450);
		signatureScene.getStylesheets().add(css);
	    signatureForm.setScene(signatureScene);
	    signatureForm.setTitle("Agent Signature");
		 
	 }


	public void show() {
		LOG.debug("show()");
		signatureForm.show();
		
	}
	
	 
	 

}
